<?php
if (!defined('ABSPATH')) {
    exit();
}

use \WCStepFilter\Filter;
use \WCStepFilter\Core;
use \WCStepFilter\Utils;

$id = isset($id) ? $id : false;

if (!$id) {
    throw new Exception('Empty filter id');
}

$arguments = Core::getTemplatePartArgs([
    'id' => $id,
    'valueList' => Filter::getValueList($id),
    'resultsUrl' => ''
]);

if (empty($arguments['valueList'])) {
    return;
}

if (isset($_REQUEST['referer'])) {
    $url = $_REQUEST['referer'];
} else {
    $url = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http')
        . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
}

$parts = parse_url($url);
$query = [];

// parse query args
if (isset($parts['query'])) {
    parse_str($parts['query'], $query);
}

// clear the referer
if (isset($query['referer'])) {
    unset($query['referer']);
}
?>
<ul class="wcsf-value">
    <?php foreach ($arguments['valueList'] as $item) { ?>
        <li class="wcsf-value-item">
            <?php
            $queryCopy = $query;

            // clear the query
            unset($queryCopy['wcsf-value'][$item->id]);

            // re-set filter id
            $queryCopy['wcsf-results'] = $arguments['id'];

            // add reset key
            $queryCopy['wcsf-reset-value'] = $item->id;

            // build query string
            $parts['query'] = http_build_query($queryCopy);

            // stringify URL parts
            $redirectLink = Utils::buildUrl($parts);
            ?>
            <a href="<?php echo esc_url($redirectLink); ?>"
                role="button"
                class="wcsf-value-item-remove"
                data-component="<?php echo $arguments['resultsUrl'] == '#' ? 'none' : 'wcsf-value-item-remove'; ?>"
                data-id="<?php echo esc_attr($item->id); ?>">
                <span class="sr-only"><?php esc_html_e('Remove', 'woocommerce-step-filter'); ?></span>
            </a>
            <span class="wcsf-value-item-name"><?php echo wp_kses_post($item->name); ?></span>:
            <span class="wcsf-value-item-value"><?php echo wp_kses_post($item->value); ?></span>
        </li>
    <?php } ?>
</ul>
