<?php
if (!defined('ABSPATH')) {
    exit();
}

use \WCStepFilter\Core;
use \WCStepFilter\Filter;

$id = isset($id) ? $id : false;
$page = isset($page) ? $page : max(1, get_query_var('paged'));
$orderBy = isset($orderBy) ? $orderBy : 'menu_order';

if (!$id) {
    throw new Exception('Empty filter id');
}

$arguments = Core::getTemplatePartArgs([
    'id' => $id,
    'productsQueryArgs' => Filter::getProductsQueryArgs(
        $id,
        [
            'orderBy' => $orderBy,
            'page' => $page
        ]
    )
]);

$productsQuery = new WP_Query($arguments['productsQueryArgs']);

do_action('wcsf_products_query', $id, $arguments, $productsQuery);

$arguments = array_replace(['productsQuery' => $productsQuery], $arguments);

echo '<div class="wcsf-products woocommerce">';

if ($productsQuery->have_posts()) {
    echo '<div class="wcsf-products-controls clearfix">';

    Core::getTemplatePart('products/result-count', $arguments);
    Core::getTemplatePart('products/pagination', $arguments);

    echo '</div>';

    woocommerce_product_loop_start();

    while ($productsQuery->have_posts()) {
        $productsQuery->the_post();

        do_action('woocommerce_shop_loop');
        wc_get_template_part('content', 'product');
    }

    woocommerce_product_loop_end();

    echo '<div class="wcsf-products-controls clearfix">';

    Core::getTemplatePart('products/order-by', $arguments);
    Core::getTemplatePart('products/result-count', $arguments);
    Core::getTemplatePart('products/pagination', $arguments);

    echo '</div>';
} else {
    /**
     * Hook: woocommerce_no_products_found.
     *
     * @hooked wc_no_products_found - 10
     */
    do_action('woocommerce_no_products_found');
}

echo '</div>';

$productsQuery->reset_postdata();
wp_reset_postdata();
wp_reset_query();
