<?php
if (!defined('ABSPATH')) {
    exit();
}

use \WCStepFilter\Filter;
use \WCStepFilter\Question;
use \WCStepFilter\Core;

$arguments = Core::getTemplatePartArgs([
    'question' => null,
    'showCount' => false,
    'fields' => []
]);

$component = 'wcsf-field-input';
?>
<div class="wcsf-field is-select form-group">
    <div class="input-group">
        <span class="input-group-addon input-group-prepend">
            <label for="wcsf-field-<?php echo esc_attr($arguments['question']->id); ?>"
                class="wcsf-field-label input-group-text"><?php
                echo wp_kses_post($arguments['question']->name);
                ?></label>
        </span>
        <select name="value[<?php echo esc_attr($arguments['question']->id); ?>][]"
            id="wcsf-field-<?php echo esc_attr($arguments['question']->id); ?>"
            class="form-control wcsf-field-input custom-select"
            data-component="<?php echo esc_attr($component); ?>"
            required>
            <?php foreach ($arguments['fields'] as $field) { ?>
                <option value="<?php echo esc_attr($field->value); ?>"<?php
                echo $field->checked ? ' selected ' : '';
                echo $field->disabled ? ' disabled ' : '';
                ?>><?php
                    echo esc_html($field->name);

                    if ($arguments['showCount'] && isset($field->count)) {
                        echo ' (' . esc_html($field->count) . ')';
                    }
                    ?></option>
            <?php } ?>
        </select>
    </div>
</div>
