<?php
if (!defined('ABSPATH')) {
    exit();
}

use \WCStepFilter\Core;

$arguments = Core::getTemplatePartArgs(
    [
        'question' => null,
        'fields' => [],
        'sliderOptions' => [
            'orientation' => 'horizontal',
            'start' => [],
            'range' => [
                'min' => 0,
                'max' => 100
            ],
            'step' => 1,
            'format' => ['decimals' => 0],
            'connect' => true,
            'binding' => []
        ]
    ],
    ['recursive' => true]
);

foreach ($arguments['fields'] as $fieldKey => $field) {
    $fieldId = "wcsf-field-$fieldKey-$arguments[id]-{$arguments['question']->id}";
    $arguments['sliderOptions']['binding'][] = "#$fieldId";
    $arguments['sliderOptions']['start'][] = $field->value;
    $arguments['sliderOptions']['step'] = $field->step;
    $arguments['sliderOptions']['format']['decimals'] = strlen(substr(strrchr($field->step, '.'), 1));
    $arguments['sliderOptions']['range'] = [
        'min' => $field->min,
        'max' => $field->max
    ];
}
?>
<div class="wcsf-fields-list is-number-between">
    <div class="wcsf-field-slider-wrapper">
        <div class="wcsf-field-slider horizontal"
            data-component="wcsf-no-ui-slider"
            data-options="<?php echo esc_attr(wp_json_encode($arguments['sliderOptions'])); ?>"></div>
    </div>
    <?php foreach ($arguments['fields'] as $fieldKey => $field) {
        $fieldId = "wcsf-field-$fieldKey-$arguments[id]-{$arguments['question']->id}";
        ?>
        <div class="wcsf-field form-group is-number-between is-number-<?php
            echo esc_attr($fieldKey);
            ?>">
            <div class="input-group">
                <span class="input-group-addon input-group-prepend">
                    <label for="<?php echo esc_attr($fieldId); ?>" class="wcsf-field-label input-group-text"><?php
                        echo wp_kses_post($field->label);
                        ?></label>
                </span>
                <input type="number"
                    step="<?php echo esc_attr($field->step); ?>"
                    id="<?php echo esc_attr($fieldId); ?>"
                    class="form-control wcsf-field-input"
                    data-component="<?php echo esc_attr($field->component); ?>"
                    name="<?php echo esc_attr($field->name); ?>"
                    value="<?php echo esc_attr($field->value); ?>">
            </div>
        </div>
    <?php } ?>
</div>
