<?php
if (!defined('ABSPATH')) {
    exit();
}

use \WCStepFilter\Core;

$arguments = Core::getTemplatePartArgs([
    'question' => null,
    'showCount' => false,
    'fields' => [],
    'currentValue' => []
]);
?>
<ul class="wcsf-fields-list form-group">
    <?php foreach ($arguments['fields'] as $field) { ?>
        <li class="wcsf-field is-multi-choice-range<?php
            echo esc_attr(' is-value-' . str_replace(' ', '-', $field->value) . ($field->disabled ? ' disabled' : ''));
            ?>">
            <span class="wcsf-field-label"><?php
                echo wp_kses_post($field->name);

                if ($arguments['showCount'] && isset($field->count)) {
                    echo ' <span class="wcsf-field-count">(' . wp_kses_post($field->count) . ')</span>';
                }
                ?></span>
            <label class="wcsf-field-value">
                <input class="wcsf-field-input wcsf-range"
                    data-component="<?php echo esc_attr($field->component); ?>"
                    onchange="this.setAttribute('value', this.value)"
                    oninput="this.setAttribute('value', this.value)"
                    name="<?php echo esc_attr("value[{$arguments['question']->id}][$field->value]"); ?>"
                    value="<?php
                    echo isset($field->currentValue[$field->value]) && $field->currentValue[$field->value]
                        ? $field->currentValue[$field->value]
                        : 0;
                    ?>"
                    type="range" step="1" min="-1" max="2">
                <?php foreach ($arguments['question']->multiChoiceValues as $possibleValue) { ?>
                    <span class="wcsf-field-name"
                        data-value="<?php echo esc_attr($possibleValue['value']); ?>"><?php
                        echo wp_kses_post($possibleValue['label']);
                        ?></span>
                <?php } ?>
            </label>
        </li>
    <?php } ?>
</ul>
