<?php
if (!defined('ABSPATH')) {
    exit();
}

use \WCStepFilter\Question;
use \WCStepFilter\Core;

$arguments = Core::getTemplatePartArgs([
    'id' => null,
    'question' => null
]);

if (!isset($arguments['question']->viewType)) {
    return;
}

$arguments['showCount'] = Question::getSetting($arguments['question']->id, 'show_count');

$classes = [
    'wcsf-fields',
    'is-' . esc_attr($arguments['question']->viewType),
    'is-question-' . esc_attr($arguments['question']->id)
];
?>
<div class="<?php echo esc_attr(implode(' ', $classes)); ?>"><?php
    Core::getTemplatePart('fields/' . $arguments['question']->viewType, $arguments);
    ?></div>
