<?php
if (!defined('ABSPATH')) {
    exit();
}

use \WCStepFilter\Filter;
use \WCStepFilter\Core;

$id = isset($id) ? $id : false;

if (!$id) {
    throw new Exception('Empty filter id');
}

$arguments = Core::getTemplatePartArgs([
    'id' => $id,
    'resetButtonText' => Filter::getSetting($id, 'reset_button_text'),
    'resultsUrl' => Filter::getSetting($id, 'results_url'),
    'resetUrl' => Filter::getResetUrl($id)
]);
?>
<a href="<?php echo esc_url($arguments['resetUrl']); ?>" class="btn btn-warning wcsf-reset"
    data-component="<?php echo $arguments['resultsUrl'] == '#' ? 'none' : 'wcsf-reset'; ?>"
    role="button"><?php echo wp_kses_post($arguments['resetButtonText']); ?></a><!--spacer-->
