<?php
if (!defined('ABSPATH')) {
    exit();
}

$arguments = \WCStepFilter\Core::getTemplatePartArgs(['productsQuery' => null]);

if (!is_object($arguments['productsQuery'])) {
    return;
}

$perPage = $arguments['productsQuery']->get('posts_per_page');
$total = $arguments['productsQuery']->found_posts;
$current = $arguments['productsQuery']->get('paged');
?>
<p class="woocommerce-result-count wcsf-products-results-count">
    <?php
    if ($total <= $perPage || -1 === $perPage) {
        /* translators: %d: total results */
        printf(_n('Showing the single result', 'Showing all %d results', $total, 'woocommerce'), $total);
    } else {
        $first = ($perPage * $current) - $perPage + 1;
        $last = min($total, $perPage * $current);
        /* translators: 1: first result 2: last result 3: total results */
        printf(
            _nx(
                'Showing the single result',
                'Showing %1$d&ndash;%2$d of %3$d results',
                $total,
                'with first and last result',
                'woocommerce'
            ),
            $first,
            $last,
            $total
        );
    }
    ?>
</p>
