<?php
if (!defined('ABSPATH')) {
    exit();
}

use \WCStepFilter\Filter;
use \WCStepFilter\Core;

$arguments = Core::getTemplatePartArgs();
$items = Filter::getProductsPaginationItems($arguments);

if (empty($items)) {
    return;
}
?>
<nav class="wcsf-products-pagination woocommerce-pagination"
    aria-label="<?php esc_attr_e('Page navigation', 'woocommerce-step-filter'); ?>">
    <ul class="wcsf-products-pagination-list page-numbers"
        data-component="wcsf-products-pagination">
        <?php foreach ($items as $item) { ?>
            <li class="page-item <?php echo esc_attr($item->class); ?>"><?php
                echo $item->innerHtml;
                ?></li>
        <?php } ?>
    </ul>
</nav>
