<?php
if (!defined('ABSPATH')) {
    exit();
}

use \WCStepFilter\Core;

$arguments = Core::getTemplatePartArgs([
    'question' => null,
    'showCount' => false,
    'fields' => []
]);
?>
<input type="hidden"
    name="value[<?php echo esc_attr($arguments['question']->id); ?>][]"
    value="">
<ul class="wcsf-fields-list form-group">
    <?php foreach ($arguments['fields'] as $field) { ?>
        <li class="wcsf-field is-checkbox checkbox form-check custom-control custom-checkbox<?php
            echo esc_attr(' is-value-' . str_replace(' ', '-', $field->value) . ($field->disabled ? ' disabled' : ''));
            ?>">
            <label class="wcsf-field-label">
                <input type="checkbox"
                    class="wcsf-field-input form-check-input custom-control-input"
                    data-component="<?php echo esc_attr($field->component); ?>"
                    name="value[<?php echo esc_attr($arguments['question']->id); ?>][]"
                    value="<?php echo esc_attr($field->value); ?>"<?php
                    echo $field->checked ? ' checked ' : '';
                    echo $field->disabled ? ' disabled ' : '';
                    ?>>
                <span class="wcsf-field-name form-check-label custom-control-label"><?php
                    echo wp_kses_post($field->name);

                    if ($arguments['showCount'] && isset($field->count)) {
                        echo ' <span class="wcsf-field-count">(' . wp_kses_post($field->count) . ')</span>';
                    }
                    ?></span>
            </label>
            <?php
            if (isset($field->children) && !empty($field->children)) {
                Core::getTemplatePart(
                    'fields/checkbox',
                    array_replace($arguments, ['fields' => $field->children])
                );
            }
            ?>
        </li>
    <?php } ?>
</ul>
