<?php
if (!defined('ABSPATH')) {
    exit();
}

use \WCStepFilter\Filter;
use \WCStepFilter\Core;

$id = isset($id) ? $id : false;

if (!$id) {
    throw new Exception('Empty filter id');
}

$arguments = Core::getTemplatePartArgs([
    'id' => $id,
    'skipButtonText' => Filter::getSetting($id, 'skip_button_text'),
    'nextStepId' => null
]);
?>
<button class="btn btn-default btn-light wcsf-skip"
    type="submit"
    name="skip"
    value="<?php echo esc_attr($arguments['nextStepId']); ?>"
    data-component="wcsf-skip wcsf-get-step"
    data-id="<?php echo esc_attr($arguments['nextStepId']); ?>"><?php
    echo wp_kses_post($arguments['skipButtonText']);
    ?></button><!--spacer-->
