<?php
if (!defined('ABSPATH')) {
    exit();
}

use \WCStepFilter\Core;
use \WCStepFilter\Filter;

$id = isset($id) ? $id : false;

if (!$id) {
    throw new Exception('Empty filter id');
}

$arguments = Core::getTemplatePartArgs([
    'id' => $id,
    'nextButtonText' => Filter::getSetting($id, 'next_button_text'),
    'nextStepId' => null,
    'step' => null
]);
?>
<button class="btn btn-primary wcsf-next"
    type="submit"
    name="stepId"
    value="<?php echo esc_attr($arguments['nextStepId']); ?>"
    data-component="wcsf-submit-and-go-next"
    data-id="<?php echo esc_attr($arguments['step']->id); ?>"><?php
    echo wp_kses_post($arguments['nextButtonText']);
    ?></button><!--spacer-->
