<?php
if (!defined('ABSPATH')) {
    exit();
}

use \WCStepFilter\Core;
use \WCStepFilter\Filter;

$id = isset($id) ? $id : false;

if (!$id) {
    throw new Exception('Empty filter id');
}

$arguments = Core::getTemplatePartArgs([
    'id' => $id,
    'backButtonText' => Filter::getSetting($id, 'back_button_text'),
    'prevStepId' => null
]);
?>
<button class="btn btn-default btn-light wcsf-back"
    type="submit"
    name="back"
    value="<?php echo esc_attr($arguments['prevStepId']); ?>"
    data-component="wcsf-back wcsf-get-step"
    data-id="<?php echo esc_attr($arguments['prevStepId']); ?>"><?php
    echo wp_kses_post($arguments['backButtonText']);
    ?></button><!--spacer-->
