<?php
/**
 * Plugin Name: WooCommerce Step Filter Lite
 * Description: Powerful and flexible plugin for creating step-by-step products filter
 * Version: 7.7.1
 * Author: troll_winner@mail.ru
 * Author URI: troll_winner@mail.ru
 */

namespace {

    if (!defined('WC_STEP_FILTER_VERSION')) {
        define('WC_STEP_FILTER_VERSION', '7.7.1');
    }

    if (!defined('WC_STEP_FILTER_PLUGIN_PATH')) {
        define('WC_STEP_FILTER_PLUGIN_PATH', plugin_dir_path(__FILE__));
    }

    if (!defined('WC_STEP_FILTER_PLUGIN_URL')) {
        define('WC_STEP_FILTER_PLUGIN_URL', plugin_dir_url(__FILE__));
    }

    if (!defined('WC_STEP_FILTER_THEME_TEMPLATES_DIR')) {
        define('WC_STEP_FILTER_THEME_TEMPLATES_DIR', 'woocommerce-step-filter');
    }

    if (!class_exists('\WCStepFilter\Core')) {
        require_once('includes/classes/Core.php');
    }

    require_once('includes/global/shortcodes.php');
}

namespace WCStepFilter {

    if (!function_exists(__NAMESPACE__  . '\Instance')) {
        function Instance()
        {
            return Core::instance();
        }
    } else {
        add_filter('admin_notices', function () {
            ?>
            <div class="notice notice-warning is-dismissible">
                <p><strong><?php L10N::e('WooCommerce Step Filter is enabled a few times'); ?></strong></p>
                <p><?php
                    // phpcs:disable
                    L10N::e('A few WooCommerce Step Filter plugins are enabled at once. Keep enabled only one of them.');
                    // phpcs:enable
                    ?></p>
            </div>
            <?php
        });
    }

    $GLOBALS['WCStepFilter'] = Instance();
}
