<?php
if (!defined('ABSPATH')) {
    exit();
}

use \WCStepFilter\Core;
use \WCStepFilter\Question;

$arguments = Core::getTemplatePartArgs([
    'id' => null,
    'step' => null
]);
?>
<article class="wcsf-step is-step-<?php echo esc_attr($arguments['step']->id); ?>">
    <?php
    foreach (WCStepFilter\Instance()->filter->getNotices($arguments['step']->id) as $notice) {
        Core::getTemplatePart('message', array_replace($arguments, $notice));
    }

    Core::getTemplatePart(
        'description',
        array_replace($arguments, ['description' => $arguments['step']->description])
    );

    $arguments['fields'] = Question::getFields($id, $arguments['step']->id);

    Core::getTemplatePart(
        'fields/index',
        array_replace(
            $arguments,
            [
                'question' => $arguments['step'],
                'fields' => Question::getFields($id, $arguments['step']->id)
            ]
        )
    );
    ?>
</article>
