<?php
if (!defined('ABSPATH')) {
    exit();
}

$arguments = \WCStepFilter\Core::getTemplatePartArgs(['navItems' => []]);
?>
<nav class="wcsf-nav is-tabs">
    <ul class="wcsf-nav-list nav nav-tabs" role="tablist">
        <?php foreach ($arguments['navItems'] as $navItem) { ?>
            <li role="presentation"
                class="wcsf-nav-list-item nav-item <?php echo esc_attr($navItem['class']); ?>">
                <button class="wcsf-nav-list-item-button nav-link <?php echo esc_attr($navItem['class']); ?>"
                    type="<?php echo esc_attr($navItem['type']); ?>"
                    name="stepId"
                    value="<?php echo esc_attr($navItem['id']); ?>"
                    data-component="<?php echo esc_attr($navItem['component']); ?>"
                    data-id="<?php echo esc_attr($navItem['id']); ?>"<?php
                    echo $navItem['disabled'] ? ' disabled ' : '';
                    ?>><?php echo wp_kses_post($navItem['name']); ?></button>
            </li>
        <?php } ?>
    </ul>
</nav>
