<?php
if (!defined('ABSPATH')) {
    exit();
}

use \WCStepFilter\Filter;
use \WCStepFilter\Core;

$id = isset($id) ? $id : false;

if (!$id) {
    throw new Exception('Empty filter id');
}

if (!get_post_status($id)) {
    throw new Exception('Filter does not exist');
}

$arguments = Core::getTemplatePartArgs([
    'id' => $id,
    'ajaxUrl' => admin_url('admin-ajax.php'),
    'categoryId' => is_product_category() ? get_queried_object()->term_id : '',
    'tagId' => is_product_tag() ? get_queried_object()->term_id : '',
    'settings' => Filter::getSettings($id, ['public' => true])
]);
?>
<section class="wcsf" data-component="wcsf" data-id="<?php echo esc_attr($arguments['id']); ?>"
    data-arguments="<?php echo esc_attr(wp_json_encode($arguments)); ?>"><?php
    Core::getTemplatePart('form', $arguments);
    ?></section>
