<?php
if (!defined('ABSPATH')) {
    exit();
}

use \WCStepFilter\Core;
use \WCStepFilter\Filter;

$id = isset($id) ? $id : false;

if (!$id) {
    throw new Exception('Empty filter id');
}

$arguments = Core::getTemplatePartArgs([
    'id' => $id,
    'navItems' => Filter::getNavItems($id),
    'resultsUrl' => Filter::getSetting($id, 'results_url'),
    'step' => Filter::getActiveStep($id),
    'steps' => Filter::getSteps($id),
    'nextButtonText' => Filter::getSetting($id, 'next_button_text'),
    'nextStepId' => Filter::getNextActiveStepId($id),
    'prevStepId' => Filter::getPrevActiveStepId($id),
    'value' => Filter::getValue($id)
]);
?>
<form class="wcsf-form"
    id="wcsf-form-<?php echo esc_attr($arguments['id']); ?>"
    action="#"
    method="POST"
    data-component="wcsf-form"
    data-step-id="<?php echo esc_attr($arguments['step']->id); ?>">
    <?php // no-js keyboard version of submit. should be upper the other ?>
    <button type="submit"
        class="sr-only"
        name="stepId"
        value="<?php echo esc_attr($arguments['nextStepId']); ?>"
        data-component="wcsf-submit-and-go-next"
        data-id="<?php echo esc_attr($arguments['step']->id); ?>"><?php
        echo wp_kses_post($arguments['nextButtonText']);
        ?></button>
    <input type="hidden" name="id" value="<?php echo esc_attr($arguments['id']); ?>">
    <input type="hidden" name="wcsf" value="<?php echo esc_attr($arguments['id']); ?>">
    <input type="hidden" name="stepId" value="<?php echo esc_attr($arguments['step']->id); ?>">
    <?php
    Core::getTemplatePart('nav/index', $arguments);
    Core::getTemplatePart('value', $arguments);

    foreach ($arguments['navItems'] as $navItem) {
        Core::getTemplatePart('nav/button', $navItem);

        if ($navItem['state'] == 'active') {
            if ($arguments['step']->id != 'results') {
                Core::getTemplatePart('step', $arguments);
            } else {
                Core::getTemplatePart('products/index', $arguments);
            }
        }
    }

    Core::getTemplatePart('controls/index', $arguments);
    ?>
</form>
