<?php
if (!defined('ABSPATH')) {
    exit();
}

use \WCStepFilter\Filter;
use \WCStepFilter\Core;

$id = isset($id) ? $id : false;

if (!$id) {
    throw new Exception('Empty filter id');
}

$arguments = Core::getTemplatePartArgs([
    'id' => $id,
    'resultsButtonText' => Filter::getSetting($id, 'results_button_text'),
    'showResultsWithin' => Filter::getSetting($id, 'show_results_within')
]);
?>
<button class="btn btn-success wcsf-results"
    type="submit"
    name="results"
    value="<?php echo esc_attr($arguments['id']); ?>"
    data-component="wcsf-results<?php echo $arguments['showResultsWithin'] ? ' wcsf-submit-and-go-to' : ''; ?>"
    data-id="results"><?php
    echo wp_kses_post($arguments['resultsButtonText']);
    ?></button><!--spacer-->
