<?php
if (!defined('ABSPATH')) {
    exit();
}

use \WCStepFilter\Core;
use \WCStepFilter\Filter;

$id = isset($id) ? $id : false;

if (!$id) {
    throw new Exception('Empty filter id');
}

$arguments = Core::getTemplatePartArgs([
    'id' => $id,
    'step' => null,
    'nextStepId' => null,
    'prevStepId' => null,
    'value' => Filter::getValue($id)
]);

$isDescriptionTab = $arguments['step']->id == 'description';
$isResultsTab = $arguments['step']->id == 'results';

echo '<nav class="wcsf-controls">';

if (!empty($arguments['value']) || $arguments['prevStepId']) {
    Core::getTemplatePart('controls/reset', $arguments);
}

if ($arguments['prevStepId']) {
    Core::getTemplatePart('controls/back', $arguments);
}

if ($arguments['nextStepId'] && !$isDescriptionTab) {
    Core::getTemplatePart('controls/skip', $arguments);
}

if ($arguments['nextStepId']) {
    Core::getTemplatePart('controls/next', $arguments);
}

if (!$arguments['nextStepId']) {
    Core::getTemplatePart('controls/results', $arguments);
}

echo '</nav>';
