<?php
namespace WCStepFilter;

/**
 * WCStepFilter Localization Class
 *
 * @class L10N
 * @version 1.0.0
 */
class L10N
{
    /**
     * Translate and return string
     *
     * @param string $string
     * @param string $domain
     *
     * @return string
     */
    public static function r($string, $domain = 'woocommerce-step-filter')
    {
        return esc_html__($string, $domain);
    }

    /**
     * Translate and echo string
     *
     * @param string $string
     * @param string $domain
     */
    public static function e($string, $domain = 'woocommerce-step-filter')
    {
        esc_html_e($string, $domain);
    }
}
